/*!
*******************************************************************************
* \file             spi_tclMySpinAudioGstreamer_v0.10.cpp
* \brief            Implements the Audio functionality for mySPIN
*******************************************************************************

DESCRIPTION:    Audio Streaming (Lib) Implementation using gstreamer v0.10
COPYRIGHT:      &copy; BSOT

******************************************************************************/

// TODO: remove workaround for levelling Android (BT) vs. iPhone (USB)??

#ifndef GST_VERSION_1

/******************************************************************************
| includes:
|----------------------------------------------------------------------------*/
#include "spi_tclMySpinAudioGstreamerInternal.h"
#include <gst/audio/gstbaseaudiosink.h> //GST_BASE_AUDIO_SINK_SLAVE_RESAMPLE

//#define MSPIN_ENABLE_GSTREAMER_DEBUGGING //enable to get GStreamer debug print outs


#define BUFF_SIZE 4096

static gboolean push_data(gpointer f_pUserData)
{
    /* PRQA: Lint Message 826: This is the standard cast of GStreamer. Ignore */
    /*lint -save -e826*/

    GstBuffer *buffer;
    guint8 *ptr;
    gint size;
    GstFlowReturn ret;
    static bool fileOpened = false;

    player *app = (player *)f_pUserData;

    if (!fileOpened) {

        app->file = open(spi_tclMySpinAudioGstreamer::gAudioSrc, O_RDONLY | O_NONBLOCK); // O_RDWR, although we do not want to write!
        // With O_RDONLY select() would return immediately whenever there is no writer (BT service, audio paused),
        // i.e. busy loop. See also CMIVI-435.

        if (app->file < 0) {
            ret = gst_app_src_end_of_stream((GstAppSrc*)app->audiosrc);
            mspin_log_printLn(eMspinVerbosityInfo, "%s(): ERROR: BT-PIPE Open Failure; errno=%d (%s)",__FUNCTION__, errno, strerror(errno) );
            return FALSE;
        } else {
            mspin_log_printLn(eMspinVerbosityInfo, "%s(): BT-PIPE Open Success",__FUNCTION__ );
            fileOpened = true;
        }
    }

    ptr = (guint8 *)g_malloc(BUFF_SIZE);
    if(!ptr)
    {
        mspin_log_printLn(eMspinVerbosityInfo, "%s(): ERROR: Allocating Input Buffer Failed. Sending End of stream",__FUNCTION__ );
        ret = gst_app_src_end_of_stream((GstAppSrc*)app->audiosrc);
        return FALSE;
    }


    fd_set l_oRSet;
    struct timeval l_oTime;
    FD_ZERO (&l_oRSet);
    FD_SET (app->file, &l_oRSet);
    l_oTime.tv_sec = 2;
    l_oTime.tv_usec = 0;

    mspin_log_printLn(eMspinVerbosityVerbose, "%s(): Waiting for 2 seconds in select",__FUNCTION__ );
    int l_iResult = select (app->file+1, &l_oRSet, NULL, NULL, &l_oTime);
    if(l_iResult <= 0)
    {
        mspin_log_printLn(eMspinVerbosityVerbose, "%s(): select TimeOut",__FUNCTION__ );

        //BOSCH_CORRECTION - Fixed deadlock in BT when returning from phone call
        //l_objLocker.unlock();
        sched_yield();
        mspin_log_printLn(eMspinVerbosityVerbose, "%s(): sched_yield()",__FUNCTION__ );
        free (ptr);
        ptr = NULL;
        return TRUE;        // !!
    }
    else
    {
        mspin_log_printLn(eMspinVerbosityVerbose, "%s(): Got Data, Proceeding to Read",__FUNCTION__ );
    }

    size = read(app->file, ptr, BUFF_SIZE);

    if(size < 0){
        mspin_log_printLn(eMspinVerbosityInfo, "%s(): ERROR: size=%d errno=%d (%s)",__FUNCTION__, size, errno, strerror(errno) );

        if( EAGAIN == errno )
        {
            mspin_log_printLn(eMspinVerbosityInfo, "%s(): Got EAGAIN",__FUNCTION__ );
            sched_yield();
            mspin_log_printLn(eMspinVerbosityInfo, "%s(): sched_yield()",__FUNCTION__ );
            free (ptr);
            ptr = NULL;
            return TRUE;
        }
        else
        {
            ret = gst_app_src_end_of_stream((GstAppSrc*)app->audiosrc);
            mspin_log_printLn(eMspinVerbosityInfo, "%s(): ERROR: eos returned %d at %d with size=%d",__FUNCTION__, ret, __LINE__, size );
            free(ptr);
            close(app->file);
            fileOpened = false;
            return FALSE;
        }
    }

    if (size == 0){
        mspin_log_printLn(eMspinVerbosityVerbose, "%s(): Read zero Bytes. Freeing Input Buffer",__FUNCTION__ );
        free(ptr);
        ptr = NULL;

        usleep(10000);

    }else{
        mspin_log_printLn(eMspinVerbosityVerbose, "%s(): Feeding buffer",__FUNCTION__ );
        buffer = gst_buffer_new();
        GST_BUFFER_MALLOCDATA(buffer) = ptr;
        GST_BUFFER_SIZE(buffer) = size;
        GST_BUFFER_DATA(buffer) = GST_BUFFER_MALLOCDATA(buffer);

        ret = gst_app_src_push_buffer((GstAppSrc*)app->audiosrc, buffer);

        if(ret !=  GST_FLOW_OK){
            mspin_log_printLn(eMspinVerbosityInfo, "%s(): ERROR: push buffer returned %d for %d bytes",__FUNCTION__, ret, size );
        }

    }

    return TRUE;
    /*lint -restore */
}

static void start_feed (GstElement * pipeline, guint size, player *app)
{
    (void)pipeline;        // unused
    (void)size;            // unused

    if (app->sourceid == 0) {
        mspin_log_printLn(eMspinVerbosityInfo, "%s(): start feeding",__FUNCTION__ );
        app->sourceid = g_idle_add ((GSourceFunc) push_data, app);
    }
}

static void stop_feed (GstElement * pipeline, player *app)
{
    (void)pipeline;        // unused

    if (app->sourceid != 0) {
        mspin_log_printLn(eMspinVerbosityInfo, "%s(): stop feeding",__FUNCTION__ );
        g_source_remove (app->sourceid);
        app->sourceid = 0;
    }
}


void spi_tclMySpinAudioGstreamerInternal::mspin_audio_readPads(GstElement* pElem)
{
    GstIterator *it = NULL;
    unsigned int done = FALSE;
    gpointer itData;
    it = gst_element_iterate_src_pads(pElem);
    while (!done)
    {
        mspin_log_printLn(eMspinVerbosityInfo, "%s(): iterating...",__FUNCTION__ );

        switch (gst_iterator_next(it, &itData))
        {
            case GST_ITERATOR_OK:
            {
                GstStructure *str = NULL;
                GstCaps *caps = NULL;
                /* PRQA: Lint Message 826: This is the standard cast of GStreamer. Ignore */
                /*lint -save -e826*/
                GstPad* pad = GST_PAD(itData);
                if (pad)
                {
                    caps = gst_pad_get_caps(pad);
                    str = gst_caps_get_structure(caps, 0);

                    mspin_log_printLn(eMspinVerbosityInfo, "%s(): for '%s'",__FUNCTION__, pad->object.name );
                    mspin_log_printLn(eMspinVerbosityInfo, "%s(): the caps are: '%s'",__FUNCTION__, gst_structure_to_string(str) );
                }
                else
                {
                    mspin_log_printLn(eMspinVerbosityInfo, "%s(): ERROR: Failed to cast itdata to GstPad",__FUNCTION__ );
                }
                /*lint -restore*/
                break;
            }
            case GST_ITERATOR_RESYNC:
            {
                gst_iterator_resync(it);
                break;
            }
            case GST_ITERATOR_ERROR:
            case GST_ITERATOR_DONE:
            {
                done = TRUE;
                break;
            }
            default:
            {
                break;
            }
        }
    }
    gst_iterator_free(it);
}

S32 spi_tclMySpinAudioGstreamerInternal::mspin_audio_create_pipeline_btsbc_alsasink( const char *const copocAudioSrc , const char *const copocAudioSink )
{
    (void)copocAudioSrc;        // unused; gAudioSrc already set in mspin_audio_start and used in start_feed/push_data
    mspin_log_printLn(eMspinVerbosityInfo, "%s(): Inside",__FUNCTION__ );

    S32 s32RetVal = 0;
    //gint64 srcLatency = 0;

    //Create pipeline
    spi_tclMySpinAudioGstreamer::gPlay.pipeline = gst_pipeline_new("pipeline");
    if (NULL == spi_tclMySpinAudioGstreamer::gPlay.pipeline)
    {
        mspin_log_printLn(eMspinVerbosityInfo, "%s(): ERROR: Could not create pipeline",__FUNCTION__ );
        s32RetVal = -1;
    }

    //Create audio src (app src)
    if( 0 == s32RetVal )
    {
           mspin_log_printLn(eMspinVerbosityInfo, "%s(): create appsrc",__FUNCTION__ );

           spi_tclMySpinAudioGstreamer::gPlay.audiosrc = gst_element_factory_make("appsrc", "src");
        if (NULL == spi_tclMySpinAudioGstreamer::gPlay.audiosrc)
        {
            mspin_log_printLn(eMspinVerbosityInfo, "%s(): ERROR: Could not create audiosrc",__FUNCTION__ );
            s32RetVal = -2;
        }
    }

    //Create SBCDEC
    if( 0 == s32RetVal )
    {
        spi_tclMySpinAudioGstreamer::gPlay.sbcdec = gst_element_factory_make("sbcdec", "sbcdec");
        if (NULL == spi_tclMySpinAudioGstreamer::gPlay.sbcdec)
        {
            mspin_log_printLn(eMspinVerbosityInfo, "%s(): ERROR: Could not create sbcdec",__FUNCTION__ );
            s32RetVal = -2;
        }
    }

    //Create queue
    if( 0 == s32RetVal )
    {
           mspin_log_printLn(eMspinVerbosityInfo, "%s(): creating queue",__FUNCTION__ );
           spi_tclMySpinAudioGstreamer::gPlay.queue = gst_element_factory_make("queue", "queue");

        if (NULL == spi_tclMySpinAudioGstreamer::gPlay.queue)
        {
            mspin_log_printLn(eMspinVerbosityInfo, "%s(): ERROR: Could not create queue",__FUNCTION__ );
            s32RetVal = -3;
        }
        else
        {

        }
    }

    //Create audio sink (USB soundcard)
    if( 0 == s32RetVal )
    {
        spi_tclMySpinAudioGstreamer::gPlay.audiosink = gst_element_factory_make("alsasink", "sink");
        if (NULL == spi_tclMySpinAudioGstreamer::gPlay.audiosink)
        {
            mspin_log_printLn(eMspinVerbosityInfo, "%s(): ERROR: Could not create audiosink",__FUNCTION__ );
            s32RetVal = -6;
        }
        else
        {
            gint64 driftTolerance = 0;
            /* PRQA: Lint Message 826: This is the standard cast of GStreamer. Ignore */
            /*lint -save -e826*/
            g_object_set(G_OBJECT(spi_tclMySpinAudioGstreamer::gPlay.audiosink), "device", copocAudioSink, NULL);
            g_object_set(G_OBJECT(spi_tclMySpinAudioGstreamer::gPlay.audiosink), "sync", FALSE , NULL); //this solves the timing issue after some time

            //Read values
            g_object_get(G_OBJECT(spi_tclMySpinAudioGstreamer::gPlay.audiosink), "drift-tolerance", &driftTolerance, NULL);
            mspin_log_printLn(eMspinVerbosityInfo, "%s(): drift tolerance of sink is %lld",__FUNCTION__, driftTolerance );
            /*lint -restore */
        }
    }

    if( 0 == s32RetVal )
    {
        mspin_log_printLn(eMspinVerbosityInfo, "%s(): All elements created",__FUNCTION__ );
        /* PRQA: Lint Message 826: This is the standard cast of GStreamer. Ignore */
        /*lint -save -e826*/

        // signal handlers for appsrc
        g_signal_connect(spi_tclMySpinAudioGstreamer::gPlay.audiosrc, "need-data", G_CALLBACK(start_feed), &spi_tclMySpinAudioGstreamer::gPlay);       // in playerengine: m_sourceid = g_timeout_add(10, (GSourceFunc) read_data, data);
        g_signal_connect(spi_tclMySpinAudioGstreamer::gPlay.audiosrc, "enough-data", G_CALLBACK(stop_feed), &spi_tclMySpinAudioGstreamer::gPlay);

        gst_bin_add_many(GST_BIN(spi_tclMySpinAudioGstreamer::gPlay.pipeline), spi_tclMySpinAudioGstreamer::gPlay.audiosrc,
        spi_tclMySpinAudioGstreamer::gPlay.sbcdec, spi_tclMySpinAudioGstreamer::gPlay.queue,            // sjm: in playerengine: without .queue
                /*gPlay.converter,
                gPlay.resampler, */ spi_tclMySpinAudioGstreamer::gPlay.audiosink, NULL);
        /*lint -restore*/
        gst_element_link_many(spi_tclMySpinAudioGstreamer::gPlay.audiosrc, spi_tclMySpinAudioGstreamer::gPlay.sbcdec, spi_tclMySpinAudioGstreamer::gPlay.queue, /*gPlay.converter,
                gPlay.resampler,*/ spi_tclMySpinAudioGstreamer::gPlay.audiosink, NULL);
    }
    return s32RetVal;
}

void* spi_tclMySpinAudioGstreamerInternal::mspin_audio_playThread(void *pArg)
{
    guint bus_watch_id;

    GstStateChangeReturn stateChangeResult;

    spi_tclMySpinAudioGstreamer *poMySpinAudioGstreamer = (spi_tclMySpinAudioGstreamer*)pArg;
    (void)poMySpinAudioGstreamer;        // currently unused

    if (!gst_is_initialized())
    {
        //Initialization
        //#define MSPIN_ENABLE_GSTREAMER_DEBUGGING
#ifdef MSPIN_ENABLE_GSTREAMER_DEBUGGING
        int argc = 2;
        char *arg0[1] = {""};
        char *arg1[1] = {"--gst-debug=*:3"};
        char **argv[] = {arg0, arg1};
        gst_init(&argc, argv);
#else
        gst_init(NULL, NULL);
#endif //MSPIN_ENABLE_GSTREAMER_DEBUGGING
       mspin_log_printLn(eMspinVerbosityInfo, "%s(): GStreamer initialized",__FUNCTION__ );
    }
    else
    {
        mspin_log_printLn(eMspinVerbosityInfo, "%s(): WARNING: GStreamer already initialized",__FUNCTION__ );
    }

    //Create main loop
    spi_tclMySpinAudioGstreamer::gPlay.loop = g_main_loop_new(NULL, FALSE);
    if (NULL == spi_tclMySpinAudioGstreamer::gPlay.loop)
    {
        mspin_log_printLn(eMspinVerbosityInfo, "%s(): ERROR: Could not create loop",__FUNCTION__ );
        return pArg;
    }
       mspin_log_printLn(eMspinVerbosityInfo, "%s(): Main loop created",__FUNCTION__ );

    //if( 0 == strcmp( "/dev/btsbc" , gAudioSrc ) )
    if ( spi_tclMySpinAudioGstreamer::gStreamDeviceType == AUDIO_DEVICE_TYPE_BT )
    {
        if( 0 != mspin_audio_create_pipeline_btsbc_alsasink(spi_tclMySpinAudioGstreamer::gAudioSrc,spi_tclMySpinAudioGstreamer::gAudioSink) )
        {
            mspin_log_printLn(eMspinVerbosityInfo, "%s(): ERROR: Could not create pipeline",__FUNCTION__ );
            return pArg;
        }
    }
    else
    {

        if( 0 != spi_tclMySpinAudioGstreamer::mspin_audio_create_pipeline_alsasrc_alsasink( spi_tclMySpinAudioGstreamer::gAudioSrc, spi_tclMySpinAudioGstreamer::gAudioSink,    //const char *const copocAudioSrc , const char *const copocAudioSink ,
                spi_tclMySpinAudioGstreamer::gAudioStreamConfig.codecName.c_str(), spi_tclMySpinAudioGstreamer::gAudioStreamConfig.sampleRate,    // char *f_pEncoding, int f_iSampleRate,
                spi_tclMySpinAudioGstreamer::gAudioStreamConfig.channels, spi_tclMySpinAudioGstreamer::gAudioStreamConfig.sampleWidth,            // int f_iChannels, int f_iSampleWidth,
                spi_tclMySpinAudioGstreamer::gAudioStreamConfig.sampleDepth, spi_tclMySpinAudioGstreamer::gAudioStreamConfig.sampleSignedness,    // int f_iSampleDepth, bool f_bSigned,
                spi_tclMySpinAudioGstreamer::gAudioStreamConfig.sampleEndianness ) )                                     // bool f_bEndianness)

        //if( 0 != mspin_audio_create_pipeline_alsasrc_alsasink(gAudioSrc,gAudioSink) )
        {
            mspin_log_printLn(eMspinVerbosityInfo, "%s(): ERROR: Could not create pipeline",__FUNCTION__ );
            return pArg;
        }

        // #### Test: iPhone 6 starts muted !!!  ########
        //g_object_set((GObject*)gPlay.volume, "mute", false, NULL);   // doesn't solve the issue
        // #### Test: levelling #########################
        //g_object_set((GObject*)gPlay.volume, "volume", 0.1, NULL);   // adapt levelling Android (BT) vs. iPhone (USB) - not used, we want same level as FM and iPod
        // ##############################################
    }

    //Adding a message filter
    /* PRQA: Lint Message 826: This is the standard cast of GStreamer. Ignore */
    /*lint -save -e826*/
    spi_tclMySpinAudioGstreamer::gPlay.bus = gst_pipeline_get_bus(GST_PIPELINE(spi_tclMySpinAudioGstreamer::gPlay.pipeline));
    /*lint -restore*/
    if (NULL == spi_tclMySpinAudioGstreamer::gPlay.bus)
    {
        mspin_log_printLn(eMspinVerbosityInfo, "%s(): ERROR: Could not create bus",__FUNCTION__ );
        return pArg;
    }
    else
    {
        bus_watch_id = gst_bus_add_watch(spi_tclMySpinAudioGstreamer::gPlay.bus, spi_tclMySpinAudioGstreamer::mspin_audio_busCall, pArg);
        gst_object_unref(spi_tclMySpinAudioGstreamer::gPlay.bus);
    }

    mspin_log_printLn(eMspinVerbosityInfo, "%s(): Start in playing mode",__FUNCTION__ );
    stateChangeResult = gst_element_set_state(spi_tclMySpinAudioGstreamer::gPlay.pipeline, GST_STATE_PLAYING);

    if (GST_STATE_CHANGE_FAILURE == stateChangeResult)
    {
        mspin_log_printLn(eMspinVerbosityInfo, "%s(): ERROR: Setting GStreamer pipeline to playing state failed",__FUNCTION__ );
    }


    mspin_log_printLn(eMspinVerbosityInfo, "%s(): Running...",__FUNCTION__ );
    g_main_loop_run(spi_tclMySpinAudioGstreamer::gPlay.loop);

    // ================ stop playback
    mspin_log_printLn(eMspinVerbosityInfo, "%s(): Run loop returned -> stopping playback",__FUNCTION__ );

    //Out of main loop, do clean up
    if (spi_tclMySpinAudioGstreamer::gPlay.pipeline)
    {
        mspin_log_printLn(eMspinVerbosityInfo, "%s(): cleaning pipeline",__FUNCTION__ );
        stateChangeResult = gst_element_set_state(spi_tclMySpinAudioGstreamer::gPlay.pipeline, GST_STATE_NULL);
        if (GST_STATE_CHANGE_FAILURE == stateChangeResult)
        {
            mspin_log_printLn(eMspinVerbosityInfo, "%s(): ERROR: Failed to change GStreamer state",__FUNCTION__ );
        }

        /* PRQA: Lint Message 826: This is the standard cast of GStreamer. Ignore */
        /*lint -save -e826*/
        gst_object_unref(GST_OBJECT(spi_tclMySpinAudioGstreamer::gPlay.pipeline));
        /*lint -restore*/
        g_source_remove(bus_watch_id);
    }

    if ( spi_tclMySpinAudioGstreamer::gStreamDeviceType == AUDIO_DEVICE_TYPE_BT ) {
        stop_feed (spi_tclMySpinAudioGstreamer::gPlay.pipeline, &spi_tclMySpinAudioGstreamer::gPlay);
    }

    if (spi_tclMySpinAudioGstreamer::gPlay.loop)
    {
        mspin_log_printLn(eMspinVerbosityInfo, "%s(): cleaning loop",__FUNCTION__ );
        g_main_loop_unref(spi_tclMySpinAudioGstreamer::gPlay.loop);
        spi_tclMySpinAudioGstreamer::gPlay.loop = NULL;
    }

    if (spi_tclMySpinAudioGstreamer::gPlay.queue)
    {
        spi_tclMySpinAudioGstreamer::gPlay.queue = NULL;
    }

    if (spi_tclMySpinAudioGstreamer::gPlay.audiosink)
    {
        spi_tclMySpinAudioGstreamer::gPlay.audiosink = NULL;
    }

    if (spi_tclMySpinAudioGstreamer::gPlay.audiosrc)
    {
        spi_tclMySpinAudioGstreamer::gPlay.audiosrc = NULL;
    }

    return pArg;
}


spi_tclMySpinAudioGstreamerInternal::spi_tclMySpinAudioGstreamerInternal()
{
    mspin_log_printLn(eMspinVerbosityInfo, "%s(): ENTER",__PRETTY_FUNCTION__ );
}

spi_tclMySpinAudioGstreamerInternal::~spi_tclMySpinAudioGstreamerInternal()
{
    mspin_log_printLn(eMspinVerbosityInfo, "%s(): ENTER",__PRETTY_FUNCTION__ );
}

#endif /* GST_VERSION_1 */

